<?php

require realpath(__DIR__ . '../../') . 'vendor/autoload.php';

use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\VehicleClassification;
use Dealerdirect\VehicleClassification\Rules\Cars\RuleSet;

$vehicle = (new Vehicle())
                ->setId(1)
                ->setDamageFree(true)
                ->setDrivable(true)
                ->setLicensePlate('9XRX22')
                ->setMakeName('CITROEN')
                ->setModelName('SAXO')
                ->setYearOfManufacture(2011)
                ->setFuelType('benzine')
                ->setMileage(150000);

// Classify the vehicle:
$vehicleClassification = new VehicleClassification(new RuleSet());
$classifiedGroupID = $vehicleClassification->classifyVehicle($vehicle);
var_dump($classifiedGroupID);
