<?php

namespace Dealerdirect\VehicleClassification\Models;

/**
 * Class MotorOption
 *
 * Motorcycle options model.
 * Contains constants specifying all static Dealerdirect Motor option values.
 *
 * @package Dealerdirect\VehicleClassification\Models
 */
class MotorOptionInterface implements VehicleOptionInterface
{
    /**
     * ABS - Anti locking brake system
     */
    public const ABS = 1;

    /**
     * Alarm system
     */
    public const ALARM = 2;

    /**
     * Luggage system
     */
    public const LUGGAGE_SYSTEM = 3;

    /**
     * Heated grips
     */
    public const HEATED_GRIPS = 4;

    /**
     * Crash bars
     */
    public const CRASH_BARS = 5;

    /**
     * Crash pads
     */
    public const CRASH_PADS = 6;

    /**
     * Windscreen
     */
    public const WINDSCREEN = 7;

    /**
     * Original exhaust system
     */
    public const EXHAUST_SYSTEM_ORIGINAL = 8;

    /**
     * Aftermarket exhaust system
     */
    public const EXHAUST_SYSTEM_AFTERMARKET = 9;

    /**
     * Original suspension
     */
    public const SUSPENSION_ORIGINAL = 10;

    /**
     * Aftermarket suspension
     */
    public const SUSPENSION_AFTERMARKET = 11;

    /**
     * Traction control
     */
    public const TRACTION_CONTROL = 12;

    /**
     * Active suspension
     */
    public const ACTIVE_SUSPENSION = 13;

    /**
     * Electronic Stability
     */
    public const ELECTRONIC_STABILITY = 14;
}
