<?php

namespace Dealerdirect\VehicleClassification\Rules;

use Dealerdirect\VehicleClassification\Rules\Rule;
use Ruler\Proposition;
use Ruler\RuleBuilder as RuleBuilderBase;

class RuleBuilder extends RuleBuilderBase
{
    /**
     * Constructor, registers our operators as well.
     */
    public function __construct()
    {
        $this->registerOperatorNamespace('\\Dealerdirect\\VehicleClassification\\Rules\\Operators');
    }

    /**
     * Create a Rule with the given propositional condition.
     *
     * @param Proposition $condition Propositional condition for this Rule
     * @param int         $groupId   Group ID to return upon successful Rule execution
     *
     * @return Rule
     */
    public function create(Proposition $condition, $groupId = null)
    {
        return new Rule($condition, $groupId);
    }
}
