<?php

namespace Dealerdirect\VehicleClassification\Rules;

use Ruler\Context;

class RuleSet
{
    protected $rules = [];

    /**
     * RuleSet constructor.-
     *
     * @param array $rules Rules to add to RuleSet
     */
    public function __construct(array $rules = [])
    {
        foreach ($rules as $rule) {
            $this->addRule($rule);
        }
    }

    /**
     * Add a Rule to the RuleSet.
     *
     * Adding duplicate Rules to the RuleSet will have no effect.
     *
     * @param Rule $rule Rule to add to the set
     */
    public function addRule(Rule $rule): void
    {
        $this->rules[spl_object_hash($rule)] = $rule;
    }

    /**
     * Execute all Rules in the RuleSet.
     *
     * @param Context $context Context with which to execute each Rule
     */
    public function executeRules(Context $context): ?int
    {
        foreach ($this->rules as $rule) {
            $result = $rule->execute($context);
            if (!is_null($result)) {
                return $result;
            }
        }
        return null;
    }
}
