<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use DealerDirect\VehicleClassification\Rules\Operators\IsEmptyEvaluator;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Variable;
use Ruler\Rule;

class GroupChecklistRules implements GroupRulesInterface
{
    private $groupRule;

    public function __construct()
    {
        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                new IsEmptyEvaluator(
                    new Variable('yearOfManufacture')
                )
            ))
        );   
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_NO_ID;
    }
}
