<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

/**
 * Base class for extending spefic premium car rules
 *
 * @package DealerDirect\VehicleClassification\Rules\Cars
 */
abstract class GroupPremiumRules implements GroupRulesInterface
{
    protected $groupRule;

    protected $premiumMakesModels;

    public function __construct() {}

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * @param array $premiumMakesModels
     */
    public function setPremiumMakesAndModels(array $premiumMakesModels)
    {
        $this->premiumMakesModels = $premiumMakesModels;
    }

    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_PREMIUM_ID;
    }

}
