<?php

namespace Dealerdirect\VehicleClassification\Models;

/**
 * Class RecreationalOption
 *
 * Recreational vehicle options model.
 * Contains constants specifying all static Dealerdirect Recreational Vehicle option values.
 *
 * @package Dealerdirect\VehicleClassification\Models
 */
class RecreationalOptionInterface implements VehicleOptionInterface
{
    public const BOILER = 101;

    public const HITCH_LOCK = 102;

    public const FLY_SCREEN = 103;

    public const CANOPY = 104;

    public const CARAVAN_MOVER = 105;

    public const OVEN = 106;

    public const STABILIZER = 107;

    public const TELEVISION_ANTENNA = 108;

    public const HEATER = 109;

    public const WATER_TANK = 110;

    public const ROOF_HOOD = 111;

    public const SHOWER = 112;

    public const FAN_HEATER = 113;

    public const MICROWAVE = 114;

    public const INVERTER = 115;

    public const U_SHAPED_SEATING_GROUP = 116;

    public const TOILET = 117;

    public const FIXED_BED = 118;

    /**
     * Awning / tent ("Voortent")
     */
    public const AWNING = 119;

    public const DRAWBAR_COVER = 120;

    public const BIKE_RACK = 121;

    /**
     * Refrigerator
     */
    public const REFRIGERATOR = 122;
    public const FRIDGE = 122;

    public const CENTRAL_KITCHEN = 123;

    /**
     * Awning windows ("Openslaande ramen")
     */
    public const AWNING_WINDOWS = 124;

    /**
     * Service hatch / "flap" ("Serviceluik")
     */
    public const SERVICE_HATCH = 125;
    public const FLAP = 125;

    public const SIDE_SEATING_ARRANGEMENT = 126;

    /**
     * Wheels / Rims ("Velgen")
     */
    public const RIMS = 127;

    /**
     * Awning light(s) ("Voortentlamp")
     */
    public const AWNING_LIGHT = 128;
}
