<?php

namespace Dealerdirect\VehicleClassification;

use Dealerdirect\Generic\Category\CallGroupsMoto;
use DealerDirect\Generic\Category\Site;
use Exception;

enum VehicleClassificationIds: int
{
    /**
     * Vehicle Classification Id's
     *
     * Values are mapped to the id's in the database table:
     * dealer01_ddmain.vehicle_classification_descriptions
     */
    case CLASSIFICATION_NO_ID = 0;
    case CLASSIFICATION_YOUNG_ID = 1;
    case CLASSIFICATION_DEMOLITION_ID = 11;
    case CLASSIFICATION_RECREATIONAL_ID = 21;
    case CLASSIFICATION_TRANSPORT_ID = 31;
    case CLASSIFICATION_BUDGET_ID = 41;
    case CLASSIFICATION_EXPORT_ID = 51;
    case CLASSIFICATION_OTHER_ID = 61;
    case CLASSIFICATION_PREMIUM_ID = 71;

    public function toCallgroupId(int $reference, bool $returnAll = false): array|int
    {
        Site::assertExists($reference);

        //phpcs:ignore PHPCompatibility.Variables.ForbiddenThisUseContexts.OutsideObjectContext
        $mapping = $this->mapping();
        if (!array_key_exists($reference, $mapping)) {
            throw new Exception('Error, could not find reference');
        }

        $callgroupIds = $mapping[$reference];

        return $returnAll
            ? $callgroupIds
            : (int) $callgroupIds[array_rand($callgroupIds)];
    }

    private function mapping()
    {
        //phpcs:ignore PHPCompatibility.Variables.ForbiddenThisUseContexts.OutsideObjectContext
        return match ($this) {
            self::CLASSIFICATION_NO_ID => [
                Site::REF_CAR_NL => [950],
                Site::REF_CAR_BE_NL => [951],
                Site::REF_CAR_BE_FR => [952],
                Site::REF_CAR_DE => [953],
                Site::REF_CAR_MARKTPLAATS_NL => [968],
                Site::REF_SCOOTER_NL => [CallGroupsMoto::NL_MOTO_CHECKLIST],
                Site::REF_MOTO_NL => [CallGroupsMoto::NL_MOTO_CHECKLIST],
                Site::REF_MOTO_BE => [CallGroupsMoto::BE_MOTO_CHECKLIST],
                Site::REF_MOTO_DE => [CallGroupsMoto::DE_MOTO_CHECKLIST],
            ],
            self::CLASSIFICATION_DEMOLITION_ID => [
                Site::REF_CAR_NL => [2],
                Site::REF_CAR_BE_NL => [12],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [62],
                Site::REF_CAR_MARKTPLAATS_NL => [80],
                Site::REF_SCOOTER_NL => [
                    CallGroupsMoto::NL_MOPED_DEMOLITION
                ],
                Site::REF_MOTO_NL => [
                    CallGroupsMoto::NL_MOTO_GROUP_1,
                    CallGroupsMoto::NL_MOTO_GROUP_2,
                    CallGroupsMoto::NL_MOTO_GROUP_3,
                    CallGroupsMoto::NL_MOTO_GROUP_4
                ],
                Site::REF_MOTO_BE => [
                    CallGroupsMoto::BE_MOTO_GROUP_1,
                    CallGroupsMoto::BE_MOTO_GROUP_2,
                    CallGroupsMoto::BE_MOTO_GROUP_3,
                    CallGroupsMoto::BE_MOTO_GROUP_4
                ],
                Site::REF_MOTO_DE => [
                    CallGroupsMoto::DE_MOTO_GROUP_1,
                    CallGroupsMoto::DE_MOTO_GROUP_2,
                ],
                Site::REF_BICYCLE_NL => [
                    CallGroupsMoto::NL_BICYCLE_NON_ELECTRIC
                ],
            ],
            self::CLASSIFICATION_EXPORT_ID => [
                Site::REF_CAR_NL => [7],
                Site::REF_CAR_BE_NL => [17],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [67],
                Site::REF_CAR_MARKTPLAATS_NL => [84],
            ],
            self::CLASSIFICATION_OTHER_ID => [
                Site::REF_CAR_NL => [8, 21],
                Site::REF_CAR_BE_NL => [18],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [65],
                Site::REF_CAR_MARKTPLAATS_NL => [85],
                Site::REF_MOTO_NL => [
                    CallGroupsMoto::NL_MOTO_GROUP_1,
                    CallGroupsMoto::NL_MOTO_GROUP_2,
                    CallGroupsMoto::NL_MOTO_GROUP_3,
                    CallGroupsMoto::NL_MOTO_GROUP_4
                ],
                Site::REF_MOTO_BE => [
                    CallGroupsMoto::BE_MOTO_GROUP_1,
                    CallGroupsMoto::BE_MOTO_GROUP_2,
                    CallGroupsMoto::BE_MOTO_GROUP_3,
                    CallGroupsMoto::BE_MOTO_GROUP_4
                ],
                Site::REF_MOTO_DE => [
                    CallGroupsMoto::DE_MOTO_GROUP_1,
                    CallGroupsMoto::DE_MOTO_GROUP_2,
                ],
                Site::REF_SCOOTER_NL => [
                    CallGroupsMoto::NL_MOPED_OTHER
                ],
            ],
            self::CLASSIFICATION_YOUNG_ID => [
                Site::REF_CAR_NL => [1],
                Site::REF_CAR_BE_NL => [11],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [61],
                Site::REF_CAR_MARKTPLAATS_NL => [79],
                Site::REF_SCOOTER_NL => [
                    CallGroupsMoto::NL_MOPED_YOUNG_FRESH
                ],
                Site::REF_MOTO_NL => [
                    CallGroupsMoto::NL_MOTO_GROUP_1,
                    CallGroupsMoto::NL_MOTO_GROUP_2,
                    CallGroupsMoto::NL_MOTO_GROUP_3,
                    CallGroupsMoto::NL_MOTO_GROUP_4
                ],
                Site::REF_MOTO_BE => [
                    CallGroupsMoto::BE_MOTO_GROUP_1,
                    CallGroupsMoto::BE_MOTO_GROUP_2,
                    CallGroupsMoto::BE_MOTO_GROUP_3,
                    CallGroupsMoto::BE_MOTO_GROUP_4
                ],
                Site::REF_MOTO_DE => [
                    CallGroupsMoto::DE_MOTO_GROUP_1,
                    CallGroupsMoto::DE_MOTO_GROUP_2,
                ],
                Site::REF_BICYCLE_NL => [
                    CallGroupsMoto::NL_BICYCLE_ELECTRIC
                ],
            ],
            self::CLASSIFICATION_BUDGET_ID => [
                Site::REF_CAR_NL => [5, 20],
                Site::REF_CAR_BE_NL => [15],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [66],
                Site::REF_CAR_MARKTPLAATS_NL => [83],
                Site::REF_MOTO_NL => [
                    CallGroupsMoto::NL_MOTO_GROUP_1,
                    CallGroupsMoto::NL_MOTO_GROUP_2,
                    CallGroupsMoto::NL_MOTO_GROUP_3,
                    CallGroupsMoto::NL_MOTO_GROUP_4
                ],
                Site::REF_MOTO_BE => [
                    CallGroupsMoto::BE_MOTO_GROUP_1,
                    CallGroupsMoto::BE_MOTO_GROUP_2,
                    CallGroupsMoto::BE_MOTO_GROUP_3,
                    CallGroupsMoto::BE_MOTO_GROUP_4
                ],
                Site::REF_MOTO_DE => [
                    CallGroupsMoto::DE_MOTO_GROUP_1,
                    CallGroupsMoto::DE_MOTO_GROUP_2,
                ],
                Site::REF_SCOOTER_NL => [
                    CallGroupsMoto::NL_MOPED_OTHER
                ],
            ],
            self::CLASSIFICATION_PREMIUM_ID => [
                Site::REF_CAR_NL => [69],
                Site::REF_CAR_BE_NL => [966],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [964],
                Site::REF_CAR_MARKTPLAATS_NL => [86],
            ],
            self::CLASSIFICATION_RECREATIONAL_ID => [
                Site::REF_CAR_NL => [3],
                Site::REF_CAR_BE_NL => [965],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [963],
                Site::REF_CAR_MARKTPLAATS_NL => [81],
            ],
            self::CLASSIFICATION_TRANSPORT_ID => [
                Site::REF_CAR_NL => [4],
                Site::REF_CAR_BE_NL => [14],
                Site::REF_CAR_BE_FR => [967],
                Site::REF_CAR_DE => [64],
                Site::REF_CAR_MARKTPLAATS_NL => [82],
            ],
        };
    }
}
