<?php

namespace Dealerdirect\VehicleClassification\Tests\Rules\Bicycle;

use Dealerdirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use Dealerdirect\VehicleClassification\Models\Vehicle;
use Dealerdirect\VehicleClassification\Rules\Bicycle\RuleSet;
use Dealerdirect\VehicleClassification\VehicleClassificationIds;
use PHPUnit\Framework\TestCase;
use Ruler\Context;

class RuleSetTest extends TestCase
{
    /**
     * @var RuleSet
     */
    private $ruleSet;

    protected function setUp(): void
    {
        $this->ruleSet = new RuleSet();
    }


    /**
     * Test cars ruleset
     *
     * @param array $vehicleData The vehicle as array
     * @param int $expectedGroupId
     *
     * @dataProvider provideExpectedData
     */
    public function testRuleSetShouldClassifySubjectsInExpectedGroup(array $vehicleData, $expectedGroupId)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $context = new Context($vehicleData);
        $this->ruleSet->executeRules($context);

        $this->assertEquals($expectedGroupId, $this->ruleSet->getResult());
    }


    /**
     * @return array<array<array>>
     */
    public static function provideExpectedData()
    {
        $currentYear = (int)date('Y');

        return [
            // Checklist
            [
                [
                    'vehicleType' => Vehicle::TYPE_BICYCLE,
                    'yearOfManufacture' => $currentYear - 20,
                ],
                VehicleClassificationIds::CLASSIFICATION_DEMOLITION_ID
            ],
            [
                [
                    'vehicleType' => Vehicle::TYPE_BICYCLE,
                    'yearOfManufacture' => $currentYear - 6,
                ],
                VehicleClassificationIds::CLASSIFICATION_DEMOLITION_ID
            ],
            [
                [
                    'vehicleType' => Vehicle::TYPE_BICYCLE,
                    'yearOfManufacture' => $currentYear - 5,
                ],
                VehicleClassificationIds::CLASSIFICATION_YOUNG_ID
            ],
            [
                [
                    'vehicleType' => Vehicle::TYPE_BICYCLE,
                    'yearOfManufacture' => $currentYear - 1,
                ],
                VehicleClassificationIds::CLASSIFICATION_YOUNG_ID
            ],
        ];
    }
}
