<?php

namespace Dealerdirect\VehicleClassification\Rules\Operators;

use Ruler\Context;
use Ruler\Operator;
use Ruler\Operator\VariableOperator;
use Ruler\Proposition;
use Ruler\VariableOperand;

/**
 * VCL Company Vehicle specific custom operator,
 * to check if string is empty
 */
class IsEmpty extends VariableOperator implements Proposition
{
    /**
     * @param Context $context Context with which to evaluate this Proposition
     *
     * @return boolean
     */
    public function evaluate(Context $context): bool
    {
        /** @var VariableOperand $checkValue */
        list($checkValue) = $this->getOperands();

        return $this->isEmpty($checkValue->prepareValue($context)->getValue());
    }

    public function isEmpty($lp)
    {
        return empty($lp);
    }

    protected function getOperandCardinality()
    {
        return Operator::UNARY;
    }
}
