<?php

namespace DealerDirect\VehicleClassification\Models\Mappers;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Utils\ArrayUtils;

/**
 * Class VehicleModelMapper
 *
 * Mapper to map Vehicle model to array and back!
 *
 * @package DealerDirect\VehicleClassification\Models\Mappers
 */
class VehicleModelMapper
{

    /**
     * @param Vehicle $vehicle The vehicle model
     *
     * @return array The vehicle model data as associative array
     */
    public function toArray(Vehicle $vehicle)
    {
        $vehicleData = array();

        $vehicleData['id'] = $vehicle->getId();
        $vehicleData['vin'] = $vehicle->getVin();
        $vehicleData['licensePlate'] = $vehicle->getLicensePlate();
        $vehicleData['vehicleType'] = $vehicle->getVehicleType();
        $vehicleData['country'] = $vehicle->getCountry();
        $vehicleData['condition'] = $vehicle->getCondition();
        $vehicleData['damageFree'] = $vehicle->isDamageFree();
        $vehicleData['drivable'] = $vehicle->isDrivable();
        $vehicleData['mileage'] = $vehicle->getMileage();
        $vehicleData['makeName'] = $vehicle->getMakeName();
        $vehicleData['modelName'] = $vehicle->getModelName();
        $vehicleData['bodyType'] = $vehicle->getBodyType();
        $vehicleData['yearOfManufacture'] = $vehicle->getYearOfManufacture();
        $vehicleData['fuelType'] = $vehicle->getFuelType();
        $vehicleData['bpm'] = $vehicle->getBpm();
        $vehicleData['askingPrice'] = $vehicle->getAskingPrice();
        $vehicleData['listPrice'] = $vehicle->getCatalogPrice();
        $vehicleData['valuationPrice'] = $vehicle->getValuationPrice();
        $vehicleData['actualValue'] = $vehicle->getActualValue();
        $vehicleData['numberOfDoors'] = $vehicle->getNumberOfDoors();
        $vehicleData['engineCapacity'] = $vehicle->getEngineCapacity();
        $vehicleData['options'] = $vehicle->getOptions();
        $vehicleData['classic'] = $vehicle->isClassic();

        return $vehicleData;
    }

    /**
     * @param array $vehicleData The vehicle as array
     *
     * @return Vehicle The mapped vehicle model
     */
    public function toVehicle(array $vehicleData)
    {
        $vehicle = new Vehicle();
        $vehicle
            ->setId(ArrayUtils::getInt($vehicleData,'id'))
            ->setVin(ArrayUtils::getValue($vehicleData, 'vin'))
            ->setLicensePlate(ArrayUtils::getValue($vehicleData, 'licensePlate'))
            ->setVehicleType(ArrayUtils::getInt($vehicleData, 'vehicleType'))
            ->setCountry(ArrayUtils::getInt($vehicleData, 'country'))
            ->setCondition(ArrayUtils::getInt($vehicleData, 'condition'))
            ->setDamageFree(ArrayUtils::getBoolean($vehicleData, 'damageFree', true))
            ->setDrivable(ArrayUtils::getBoolean($vehicleData, 'driveable', true))
            ->setMileage(ArrayUtils::getInt($vehicleData, 'mileage'))
            ->setMakeName(ArrayUtils::getValue($vehicleData, 'makeName'))
            ->setModelName(ArrayUtils::getValue($vehicleData, 'modelName'))
            ->setYearOfManufacture(ArrayUtils::getInt($vehicleData, 'yearOfManufacture', 0))
            ->setBodyType(ArrayUtils::getInt($vehicleData, 'bodyType'))
            ->setFuelType(ArrayUtils::getValue($vehicleData, 'fuelType'))
            ->setBpm(ArrayUtils::getInt($vehicleData, 'bpm'))
            ->setNumberOfDoors(ArrayUtils::getInt($vehicleData, 'numberOfDoors'))
            ->setEngineCapacity(ArrayUtils::getInt($vehicleData, 'engineCapacity'))
            ->setAskingPrice(ArrayUtils::getInt($vehicleData, 'askingPrice'))
            ->setCatalogPrice(ArrayUtils::getInt($vehicleData, 'listPrice'))
            ->setValuationPrice(ArrayUtils::getInt($vehicleData, 'valuationPrice'))
            ->setActualValue(ArrayUtils::getInt($vehicleData, 'actualValue'))
            ->setOptions(ArrayUtils::getArray($vehicleData, 'options'))
            ->setClassic(ArrayUtils::getBoolean($vehicleData, 'classic', false))
            ;
        return $vehicle;
    }

}
