<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupDemolitionRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupDemolition
     */
    public function testGroupDemolitionCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupDemolitionRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupDemolition
     */
    public function testGroupDemolitionWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupDemolitionRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupDemolition()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => false,
                'mileage' => 62000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => $currentYear-11,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => false,
                'mileage' => 82000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => $currentYear-11,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => false,
                'mileage' => 100000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => false,
                'mileage' => 81000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 62000,
                'makeName' => 'YAMAHA',
                'modelName' => '100',
                'yearOfManufacture' => 1984,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 750
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupDemolition()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => $currentYear-6,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => $currentYear-5,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 50000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 101000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => $currentYear-8,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 11000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 26000,
                'makeName' => 'HONDA',
                'modelName' => 'CBR 900 RR FIREBLADE',
                'yearOfManufacture' => $currentYear-21,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 184000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 R ROCKSTER',
                'yearOfManufacture' => $currentYear-13,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 75000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 70000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => $currentYear-17,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 84000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 R ROCKSTER',
                'yearOfManufacture' => $currentYear-17,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 62000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => 1984,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            // Classics:
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'YAMAHA',
                'modelName' => 'Classic1',
                'yearOfManufacture' => 1985,
                'classic' => '1',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'HONDA',
                'modelName' => 'Classic2',
                'yearOfManufacture' => 1976,
                'classic' => '0',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 1500
            )),
        );
    }
}
