<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupHighWithKMRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupHighWitHKM
     */
    public function testGroupHighWitHKMCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupHighWitHKMRules = new GroupHighWithKMRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupHighWitHKMRules->evaluate($context));
    }

    /**
     * Test high group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupHighWitHKM
     */
    public function testGroupHighWitHKMWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupHighWitHKMRules = new GroupHighWithKMRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupHighWitHKMRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupHighWitHKM()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 120001,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 2014,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 200000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupHighWitHKM()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 119000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 2003,
                'fuelType' => '1',
                'bpm' => '10156',
                'askingPrice' => 1650
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 119001,
                'makeName' => 'SUZUKI',
                'modelName' => 'ALTO',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '1361',
                'askingPrice' => 750
            )), array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '0',
                'drivable' => '1',
                'mileage' => 113000,
                'makeName' => 'SEAT',
                'modelName' => 'IBIZA',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '3024',
                'askingPrice' => 0
            ))
        );
    }
}
