<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

/**
 * Class GroupToyotaExportRules
 *
 * Specific Export Rules for TOYOTA cars
 *
 * @package DealerDirect\VehicleClassification\Rules\Cars
 */
class GroupToyotaExportRules implements GroupRulesInterface
{
    private $groupRule;

    public function __construct()
    {
        $currentYear = (int)date('Y');

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('makeName', 'TOYOTA'),
                    ConditionUtils::lessThanOrEqualTo('yearOfManufacture', $currentYear - 13),
                ))
            ))
        );
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_EXPORT_TOYOTA_ID;
    }
}
