<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupToyotaExportRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test Export group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupExportToyota
     */
    public function testGroupExportCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupExportRules = new GroupToyotaExportRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupExportRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupExportToyota
     */
    public function testGroupExportWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupExportRules = new GroupToyotaExportRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupExportRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupExportToyota()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'makeName' => 'TOYOTA',
                'modelName' => 'Corolla',
                'yearOfManufacture' => 1993,
                'fuelType' => FuelUtils::GASOLINE,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 1000,
                'numberOfDoors' => 4
            )),
            // Diesel + 3 doors case:
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'makeName' => 'TOYOTA',
                'modelName' => 'Corolla',
                'yearOfManufacture' => 2003,
                'fuelType' => FuelUtils::DIESEL,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 1000,
                'numberOfDoors' => 3
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupExportToyota()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'makeName' => 'TOYOTA',
                'modelName' => 'Corolla',
                'yearOfManufacture' => 2012,
                'fuelType' => FuelUtils::DIESEL,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 1000,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'makeName' => 'TOYOTA',
                'modelName' => 'Corolla',
                'yearOfManufacture' => 2010,
                'fuelType' => FuelUtils::GASOLINE,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 1000,
                'numberOfDoors' => 5
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'makeName' => 'TOYOTA',
                'modelName' => 'Celica',
                'yearOfManufacture' => 2006,
                'fuelType' => FuelUtils::GASOLINE,
                'mileage' => 204000,
                'bpm' => 409,
                'askingPrice' => 3000,
                'numberOfDoors' => 2
            )),
        );
    }
}
