<?php

namespace DealerDirect\VehicleClassification;

use DealerDirect\VehicleClassification\Rules\Cars;
use DealerDirect\VehicleClassification\Rules\Motors;

/**
 * Class DefaultGroupRulesSetsFactory
 *
 * Factory to create default sets of Group Rules for DealerDirect
 *
 * @package DealerDirect\VehicleClassification
 */
abstract class DefaultGroupRulesSetsFactory
{

    /**
     * Get a set of GroupRules for car vehicles
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of car nl group rules
     */
    public static function getDefaultCarGroupRulesSet()
    {
        return array(
            new Cars\GroupRecreationalRules(),
            new Cars\GroupTransportRules(),
            new Cars\GroupPremiumExclusiveRules(),
            new Cars\GroupChecklistRules(),
            new Cars\GroupToyotaExportRules(),
            new Cars\GroupPremiumClassicRules(),
            new Cars\GroupDemolitionRules(),
            new Cars\GroupLowWithKMRules(),
            new Cars\GroupExportRules(),
            new Cars\GroupLowRules(),
            new Cars\GroupHighRules(),
            new Cars\GroupHighWithKMRules(),
            new Cars\GroupYoungRules(),
        );
    }

    /**
     * Get a set of GroupRules for motorcycle vehicles
     *
     * @return array<\DealerDirect\VehicleClassification\Rules\GroupRulesInterface> Returns array of motor group rules
     */
    public static function getDefaultMotoGroupRulesSet()
    {
        return array(
            new Motors\GroupScooterRules(),
            new Motors\GroupDemolitionRules(),
            new Motors\GroupBudgetRules(),
            new Motors\GroupOtherRules(),
            new Motors\GroupYoungRules(),
        );
    }

}
