<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupBudgetRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupBudget
     */
    public function testGroupBudgetCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupBudgetRules = new GroupBudgetRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupBudgetRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupBudget
     */
    public function testGroupBudgetWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupBudgetRules = new GroupBudgetRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupBudgetRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupBudget()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 50000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 70000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-13,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 55000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => $currentYear-20,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 70000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => $currentYear-18,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 75000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 70000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => $currentYear-17,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 84000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 R ROCKSTER',
                'yearOfManufacture' => $currentYear-17,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 26000,
                'makeName' => 'HONDA',
                'modelName' => 'CBR 900 RR FIREBLADE',
                'yearOfManufacture' => $currentYear-22,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupBudget()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '0',
                'mileage' => 33000,
                'makeName' => 'HONDA',
                'modelName' => 'X3',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 112400,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 3000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 120000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 40000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2007,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 105000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 R ROCKSTER',
                'yearOfManufacture' => $currentYear-17,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 R ROCKSTER',
                'yearOfManufacture' => $currentYear-13,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 82136,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'FLHT - FLHTI ELECTRA GLIDE STANDARD',
                'yearOfManufacture' => 1996,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4400
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 70000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'Harley',
                'yearOfManufacture' => $currentYear-13,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 62000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => 1984,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 38000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 GS',
                'yearOfManufacture' => $currentYear-16,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 0
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 35000,
                'makeName' => 'BMW',
                'modelName' => 'K1200 LT',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2000
            )),
            // Classics:
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'YAMAHA',
                'modelName' => 'Classic1',
                'yearOfManufacture' => 1985,
                'classic' => '1',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'HONDA',
                'modelName' => 'Classic2',
                'yearOfManufacture' => 1976,
                'classic' => '0',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 1500
            )),
        );
    }
}
