<?php

namespace DealerDirect\VehicleClassification\Rules\Operators;

use Ruler\Context;
use Ruler\Operator;
use Ruler\Operator\VariableOperator;
use Ruler\Proposition;
use Ruler\VariableOperand;



/**
 * VCL Company Vehicle specific custom operator,
 * to check whether given license plate string is according to Dutch Company license plate rules.
 *
 * Evaluation will result in true when given String value contains as first letter in the string a 'B' or a 'V'
 *
 */
class CompanyLicensePlateEvaluator extends VariableOperator implements Proposition
{
    /**
     * @param Context $context Context with which to evaluate this Proposition
     *
     * @return boolean
     */
    public function evaluate(Context $context)
    {
        /** @var VariableOperand $checkValue */
        list($checkValue) = $this->getOperands();

        return $this->isCompanyVehicleByLicensePlate( $checkValue->prepareValue($context)->getValue() );
    }

    public function isCompanyVehicleByLicensePlate($lp) {
        $lettersOnly = preg_replace("/[^A-Za-z]/", '', $lp);
        return (strpos($lettersOnly, 'V') === 0 || strpos($lettersOnly, 'B') === 0);
    }

    protected function getOperandCardinality()
    {
        return Operator::UNARY;
    }
}
