<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupOtherRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupOther
     */
    public function testGroupOtherCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupOtherRules = new GroupOtherRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupOtherRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupOther
     */
    public function testGroupOtherWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupOtherRules = new GroupOtherRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupOtherRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupOther()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '2',
                'mileage' => 3600,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => $currentYear-11,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 14000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-9,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 15000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => $currentYear-13,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 79000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 75000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 75000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => $currentYear-10,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 45000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-11,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6500
            )),
            // Classics:
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'YAMAHA',
                'modelName' => 'Classic1',
                'yearOfManufacture' => 1985,
                'classic' => '1',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'HONDA',
                'modelName' => 'Classic2',
                'yearOfManufacture' => 1976,
                'classic' => '0',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 1500
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupOther()
    {
        $currentYear = (int)date('Y');
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => $currentYear-6,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 25850,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => $currentYear-5,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => $currentYear-7,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 120000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => $currentYear-19,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 101000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => $currentYear-10,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 60000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-4,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 13500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 26000,
                'makeName' => 'HONDA',
                'modelName' => 'CBR 900 RR FIREBLADE',
                'yearOfManufacture' => $currentYear-20,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2350
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 45000,
                'makeName' => 'HARLEY-DAVIDSON',
                'modelName' => 'VM04',
                'yearOfManufacture' => $currentYear-10,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 13500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 35000,
                'makeName' => 'BMW',
                'modelName' => 'K1200 LT',
                'yearOfManufacture' => $currentYear-12,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2000
            )),
            // NOT Classics:
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 89000,
                'makeName' => 'YAMAHA',
                'modelName' => 'Classic1',
                'yearOfManufacture' => 1985,
                'classic' => '0',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2500
            )),
            // Damaged classic:
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '0',
                'mileage' => 126000,
                'makeName' => 'HONDA',
                'modelName' => 'Classic2',
                'yearOfManufacture' => 1976,
                'classic' => '0',
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 0
            ))
        );
    }
}
