<?php

namespace Dealerdirect\VehicleClassification\Rules;

use Ruler\Proposition;
use Ruler\Context;

class Rule implements Proposition
{
    /**
     * @var Proposition
     */
    protected $condition;

    /**
     * @var int
     */
    protected $groupId;

    /**
     * Rule constructor.
     *
     * @param Proposition $condition Propositional condition for this Rule
     * @param groupId     $groupId   Group ID to return upon successful Rule execution
     */
    public function __construct(Proposition $condition, $groupId = null)
    {
        $this->condition = $condition;
        $this->groupId = $groupId;
    }

    /**
     * Evaluate the Rule with the given Context.
     *
     * @param Context $context Context with which to evaluate this Rule
     *
     * @return boolean
     */
    public function evaluate(Context $context)
    {
        return $this->condition->evaluate($context);
    }

    /**
     * Execute the Rule with the given Context.
     *
     * The Rule will be evaluated, and if successful, will return the
     * group ID.
     *
     * @param  Context  $context Context with which to execute this Rule
     * @throws \LogicException
     */
    public function execute(Context $context): ?int
    {
        if ($this->evaluate($context)) {
            return $this->groupId;
        }
        return null;
    }
}
