<?php
namespace DealerDirect\VehicleClassification\Rules;

use Ruler\Context;

interface RuleSetInterface
{
    /**
     * Add a Vehicle Group rule to the rule set
     * @param $rule GroupRule
     */
    public function addRule(GroupRule $rule);

    /**
     * Returns rule at given index in ruleset
     * @param $index
     * @return GroupRule
     */
    public function get($index);

//    public function next()
//    {
//        $this->index += 1;
//        if ($this->index >= sizeof($this->rules)) {
//            return null;
//        }
//        return $this->rules[$this->index];
//    }
//
//    /**
//     * Reset iterator index
//     */
//    public function reset()
//    {
//        $this->index = -1;
//    }

    /**
     * Evaluate context with specified rule sin this ruleset
     * and return a resulting target group id
     * When no match is found, -1 will be returned
     *
     * @param Context $context The vehicle context
     * @return mixed
     */
    public function evaluate(Context $context);
}
