# Vehicle Classification Library

(aka VCL)

## Introduction
The Vehicle Classification Library is a multiple rulesets implementation to 
classify vehicles registered at DealerDirect. These include: cars, motorcycles, 
recreational and transport vehicles.
Implementation of rules is done using the `ruler/ruler` package 


## Usage

### Vehicle Classification

Classifying a vehicle is done by passing a `Vehicle model` to the main 
`VehicleClassification` processor.
It runs the supplied vehicle through a set of pre defined rules and will return
a "Classification Group ID", which is a suggestion in which
category to place the vehicle for DealerDirect.

### Implementation

Can be implemented as follows:

1) Add the repository to your `composer.json`:

```json
"repositories": [
    {
        "type": "git",
        "url": "git@git.dealerdirect.io:php-packages/vehicle-classification.git"
    }
]
```

2) Include in your code:

```php
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\VehicleClassification;
use DealerDirect\VehicleClassification\DefaultGroupRulesSetsFactory;

$vehicle = (new Vehicle())
                ->setId(1)
                ->setDamageFree(true)
                ->setDrivable(true)
                ->setLicensePlate('9XRX22')
                ->setMakeName('CITROEN')
                ->setModelName('SAXO')
                ->setYearOfManufacture(2011)
                ->setFuelType('benzine')
                ->setMileage(150000);

// Classify the vehicle
$vehicleClassification = VehicleClassification::create(DefaultGroupRulesSetsFactory::getAllGroupSets());
$classifiedGroupID = $vehicleClassification->classifyVehicle($vehicle);

```

### Example

There is an example `index.php` in the `scripts/examples` directory.
You can run this as follows:
    
```
php -S localhost:8888 -l scripts/examples/index.php
```


## Testing

Testing is done using PHPUnit.
You can execute this running in the root of the repository directory:
    
```
phpunit
```


## Extending the library

### Rules

Classification rules are created by implementing the `GroupRules` interface.
