<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupBudgetRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupBudget
     */
    public function testGroupBudgetCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupBudgetRules = new GroupBudgetRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupBudgetRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupBudget
     */
    public function testGroupBudgetWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupBudgetRules = new GroupBudgetRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupBudgetRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupBudget()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 50000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 1999,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 70000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 55000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 90000,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 99000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 80000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2001,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupBudget()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 112400,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 3000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 120000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 101000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2007,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 10000
            ))
        );
    }
}
