<?php

namespace DealerDirect\VehicleClassification\Models;

/**
 * Class CarOption
 *
 * Car options model.
 * Contains constants specifying all static DealerDirect Car option values.
 *
 * @package DealerDirect\VehicleClassification\Models
 */
class CarOption implements VehicleOptionInterface
{
    /**
     * Air Conditioning
     */
    const AIR_CONDITIONING = 1;

    /**
     * ABS - Anti locking brake system
     */
    const ABS = 2;

    /**
     * 4x4
     */
    const FOUR_BY_FOUR = 3;

    /**
     * Automatic Air Conditiong / Climate Control
     */
    const AIR_CONDITIONING_AUTOMATIC = 4;
    const CLIMATE_CONTROL = 4;

    const AIRBAG = 5;

    /**
     * Vehicle has (additional) tuning
     */
    const TUNING = 6;

    /**
     * Leather upholstery / interior ("Leren bekleding")
     */
    const LEATHER_UPHOLSTERY = 7;

    /**
     * Passenger's side airbag
     */
    const AIRBAG_PASSENGER_SIDE = 8;

    /**
     * Alloy wheels ("Lichtmetalen velgen")
     */
    const ALLOY_WHEELS = 9;

    const ELECTRIC_WINDOWS = 10;

    /**
     * Side airbags
     */
    const AIRBAGS_SIDE = 11;

    const ROOF_RAILS = 12;

    /**
     * GPS / Navigation
     */
    const GPS_NAVIGATION = 13;

    /**
     * Xenon headlights
     */
    const XENON_LIGHTS = 14;

    /**
     * On-board Computer ("Boordcomputer")
     */
    const ONBOARD_COMPUTER = 15;

    const POWER_SEATS = 16;

    const POWER_DOOR_LOCKS = 17;

    /**
     * Parking assistance
     */
    const PARKING_ASSIST = 18;

    /**
     * Sun/Moon Roof
     */
    const SUN_ROOF = 19;

    /**
     * Alarm system
     */
    const ALARM = 20;

    const FOG_LIGHTS = 21;

    const HEATED_SEATS = 22;

    const IMMOBILIZER = 23;

    const POWER_STEERING = 24;

    /**
     * CD Player
     */
    const AUDIO_CD_PLAYER = 25;

    const TRACTION_CONTROL = 26;

    const CRUISE_CONTROL = 27;

    /**
     * Radio/cassette
     */
    const AUDIO_RADIO_CASSETTE = 28;

    /**
     * ESP - Electronic stability program
     */
    const ESP = 29;

    /**
     * Towbar ("Trekhaak")
     */
    const TOWBAR = 30;

    /**
     * Panoramic Sun Roof
     */
    const SUN_ROOF_PANORAMIC = 31;



}
