<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

/**
 * Base class for extending spefic premium car rules
 *
 * @package DealerDirect\VehicleClassification\Rules\Cars
 */
abstract class GroupPremiumRules implements GroupRulesInterface
{
    /**
     * @var Rule
     */
    protected $groupRule;

    /**
     * @var array
     */
    protected $premiumMakesModels;

    public function __construct()
    {
        $currentYear = (int)date('Y');

        // NOTE: For now we check exclusive makes his way:
        // This list was created subjectively!
        $this->premiumMakesModels = array(
            'ACURA',
            'AUDI',
            'BMW',
            'INFINITI',
            'JEEP',
            'LANCIA',
            'LAND-ROVER',
            'LEXUS',
            'LINCOLN',
            'MERCEDES',
            'MERCEDES-BENZ',
            'TESLA',
            'VOLVO',
        );

        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                // Premium Exclusive models, > year 2001
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                    ConditionUtils::equalTo('damageFree', true),
                    ConditionUtils::equalTo('drivable', true),
                    ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 16),
                    ConditionUtils::isOneOf('makeName', $this->premiumMakesModels)
                ))
            ))
        );
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * @param array $premiumMakesModels
     */
    public function setPremiumMakesAndModels(array $premiumMakesModels)
    {
        $this->premiumMakesModels = $premiumMakesModels;
    }

    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_PREMIUM_ID;
    }

}
