<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\VehicleCountry;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Rules\Operators\CompanyLicensePlateEvaluator;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;
use Ruler\Variable;

class GroupTransportRules implements GroupRulesInterface
{
    /**
     * @var Rule
     */
    private $groupRule;

    public function __construct()
    {
        /*
         * Vehicle is either of type 'TRANSPORT'
         * Or any *NL based* vehicle, with license plate starting with 'V' or 'B'
         */
        $this->groupRule = new Rule(
            new Operator\LogicalOr(array(
                ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_TRANSPORT),
                new Operator\LogicalAnd(array(
                    ConditionUtils::equalTo('country', VehicleCountry::NETHERLANDS),
                    new CompanyLicensePlateEvaluator(
                        new Variable('licensePlate')
                    )
                ))
            ))
        );
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_TRANSPORT_ID;
    }
}
