<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;
use DealerDirect\VehicleClassification\Utils\ConditionUtils;
use Ruler\Context;
use Ruler\Operator;
use Ruler\Rule;

class GroupYoungRules implements GroupRulesInterface
{
    /**
     * @var Rule
     */
    private $groupRule;

    public function __construct()
    {
        $currentYear = (int)date('Y');

        $this->groupRule = new Rule(
            new Operator\LogicalAnd(array(
                ConditionUtils::equalTo('vehicleType', Vehicle::TYPE_CAR),
                ConditionUtils::equalTo('damageFree', true),
                ConditionUtils::equalTo('drivable', true),
                ConditionUtils::greaterThanOrEqualTo('yearOfManufacture', $currentYear - 8),
                ConditionUtils::lessThan('mileage', 120000)
            ))
        );
    }

    /**
     * @param Context $context
     * @return bool
     */
    public function evaluate(Context $context)
    {
        return $this->groupRule->evaluate($context);
    }

    /**
     * Returns VCL internal group ID
     *
     * @return int
     */
    public function getGroupId()
    {
        return GroupRulesInterface::GROUP_CARS_YOUNG_ID;
    }
}
