<?php

namespace DealerDirect\VehicleClassification\Rules\Cars;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Models\VehicleCountry;
use Ruler\Context;

class GroupTransportRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupTransport
     */
    public function testGroupTransportCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupTransportRules = new GroupTransportRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupTransportRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupTransport
     */
    public function testGroupTransportWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupTransportRules = new GroupTransportRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupTransportRules->evaluate($context));
    }

    /**
     * Array of Transport Vehicle arrays Data provider
     *
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupTransport()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_TRANSPORT,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 60000,
                'makeName' => 'RENAULT',
                'modelName' => 'KANGOO',
                'yearOfManufacture' => 2015,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => '30000'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_UNKNOWN,
                'country' => VehicleCountry::NETHERLANDS,
                'licensePlate' => 'V32B44',
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 65000,
                'makeName' => 'OPEL',
                'modelName' => 'VIVARO',
                'yearOfManufacture' => 2015,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => '30000'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'country' => VehicleCountry::NETHERLANDS,
                'licensePlate' => 'B37AB1',
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 141954,
                'makeName' => 'VOLKSWAGEN',
                'modelName' => 'TRANSPORTER',
                'yearOfManufacture' => 1999,
                'fuelType' => '1',
                'bpm' => '2434',
                'askingPrice' => '1000'
            ))
        );
    }

    /**
     * Array of *NOT* Transport Vehicle arrays Data provider
     *
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupTransport()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'licensePlate' => 'XJ452B',
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 88000,
                'makeName' => 'VOLVO',
                'modelName' => 'AMAZON',
                'yearOfManufacture' => 1969,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => '0'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 140000,
                'makeName' => 'SKODA',
                'modelName' => 'SUPERB',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '8284',
                'askingPrice' => '17000'
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_UNKNOWN,
                'country' => VehicleCountry::BELGIUM,
                'licensePlate' => 'BVB32OH',
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 155000,
                'makeName' => 'AUDI',
                'modelName' => 'A3',
                'yearOfManufacture' => 2002,
                'fuelType' => '1',
                'bpm' => '409',
                'askingPrice' => 500,
                'numberOfDoors' => 5
            )),
        );
    }
}
