<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupDemolitionRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupDemolition
     */
    public function testGroupDemolitionCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupDemolitionRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupDemolition
     */
    public function testGroupDemolitionWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupDemolitionRules = new GroupDemolitionRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupDemolitionRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupDemolition()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => false,
                'mileage' => 62000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '2',
                'mileage' => 82000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 100000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 81000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 112400,
                'makeName' => 'BMW',
                'modelName' => '328 IA',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 3000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 62000,
                'makeName' => 'YAMAHA',
                'modelName' => '100',
                'yearOfManufacture' => 1984,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 750
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupDemolition()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 85000,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 50000,
                'makeName' => 'HONDA',
                'modelName' => 'PAN EUROPEAN',
                'yearOfManufacture' => 1998,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 5000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => true,
                'mileage' => 101000,
                'makeName' => 'HONDA',
                'modelName' => 'VALKYRIE INTERSTATE',
                'yearOfManufacture' => 2009,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 11000
            ))
        );
    }
}
