<?php

namespace Dealerdirect\VehicleClassification\Rules;

use Dealerdirect\VehicleClassification\VehicleClassificationIds;
use Ruler\Context;
use Ruler\Rule;
use Ruler\RuleBuilder;
use Ruler\RuleSet as BaseRuleSet;

class RuleSet extends BaseRuleSet
{
    protected ?VehicleClassificationIds $result = null;

    /**
     * Execute all Rules in the RuleSet.
     *
     * @param Context $context Context with which to execute each Rule
     */
    public function executeRules(Context $context): void
    {
        foreach ($this->rules as $rule) {
            $rule->execute($context);
            // Stop executing more rules after first match
            if ($this->result !== null) {
                return;
            }
        }
    }

    public function getResult(): ?VehicleClassificationIds
    {
        return $this->result;
    }

    protected function getRuleBuilder()
    {
        return (new RuleBuilder())
            ->registerOperatorNamespace('\\Dealerdirect\\VehicleClassification\\Rules\\Operators');
    }
}
