<?php

namespace DealerDirect\VehicleClassification\Rules\Motors;

use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use Ruler\Context;

class GroupYoungRulesTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Test young group ruleset
     *
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideCorrectDataGroupYoung
     */
    public function testGroupYoungCorrectData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupYoungRules = new GroupYoungRules();
        $context = new Context($vehicleData);

        $this->assertTrue($groupYoungRules->evaluate($context));
    }

    /**
     * Test young group ruleset
     * @param array $vehicleData The vehicle as array
     *
     * @dataProvider provideWrongDataGroupYoung
     */
    public function testGroupYoungWrongData(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        // Check rules
        $groupYoungRules = new GroupYoungRules();
        $context = new Context($vehicleData);

        $this->assertFalse($groupYoungRules->evaluate($context));
    }

    /**
     * @return array<array<array>>
     */
    public static function provideCorrectDataGroupYoung()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 14507,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M64',
                'yearOfManufacture' => 2009,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4750
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 22000,
                'makeName' => 'YAMAHA',
                'modelName' => 'XT 660 R',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 3300
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 19700,
                'makeName' => 'DUCATI',
                'modelName' => 'MONSTER 796',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 25850,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            )),
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideWrongDataGroupYoung()
    {
        return array(
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 25675,
                'makeName' => 'YAMAHA',
                'modelName' => 'YZF R6',
                'yearOfManufacture' => 2000,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2200
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 43000,
                'makeName' => 'BMW',
                'modelName' => 'R 1150 GS',
                'yearOfManufacture' => 2001,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 0
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 13311,
                'makeName' => 'KYMCO',
                'modelName' => 'VITALITY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 49900,
                'makeName' => 'KAWASAKI',
                'modelName' => 'ZR-7S',
                'yearOfManufacture' => 2001,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 1400
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '2',
                'mileage' => 35000,
                'makeName' => 'SUZUKI',
                'modelName' => 'VL 1500',
                'yearOfManufacture' => 2005,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6200
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 30260,
                'makeName' => 'BMW',
                'modelName' => 'R 850 R',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4000
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => 0,
                'mileage' => 33974,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M64',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4200
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 35000,
                'makeName' => 'YAMAHA',
                'modelName' => 'XV 1000',
                'yearOfManufacture' => 1984,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 1500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 27000,
                'makeName' => 'YAMAHA',
                'modelName' => 'XV750 VIRAGO',
                'yearOfManufacture' => 1989,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 950
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '2',
                'mileage' => 3600,
                'makeName' => 'PIAGGIO',
                'modelName' => 'FLY',
                'yearOfManufacture' => 2006,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 75
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 14000,
                'makeName' => 'YAMAHA',
                'modelName' => 'VM04',
                'yearOfManufacture' => 2008,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6500
            )),
            array(array(
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 15000,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M34',
                'yearOfManufacture' => 2004,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 2800
            ))
        );
    }
}