<?php
namespace DealerDirect\VehicleClassification;

use DealerDirect\VehicleClassification\Models\FuelUtils;
use DealerDirect\VehicleClassification\Models\Mappers\VehicleModelMapper;
use DealerDirect\VehicleClassification\Models\Vehicle;
use DealerDirect\VehicleClassification\Rules\GroupRulesInterface;

/**
 * Class VehicleClassificationClassTest
 * @package DealerDirect\VehicleClassification\Tests
 */
class VehicleClassificationClassTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @param $vehicleData
     *
     * @dataProvider provideDataGroupMotor
     */
    public function testVehicleClassificationAllOnMotorGroupYoung(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        $vehicleClassification = VehicleClassification::create(DefaultGroupRulesSetsFactory::getDefaultMotoGroupRulesSet());

        $classifiedId = $vehicleClassification->suggestClassifications($vehicle);

        $this->assertEquals(GroupRulesInterface::GROUP_MOTORS_YOUNG_ID, $classifiedId[0]);
    }

    /**
     * @param $vehicleData
     *
     * @dataProvider provideDataGroupCarExport
     */
    public function testVehicleClassificationAllOnCarGroupExport(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        $vehicleClassification = VehicleClassification::create(DefaultGroupRulesSetsFactory::getDefaultCarGroupRulesSet());

        $classifiedId = $vehicleClassification->suggestClassifications($vehicle);

        $this->assertEquals(GroupRulesInterface::GROUP_CARS_EXPORT_ID, $classifiedId[0]);
    }

    /**
     * @param $vehicleData
     *
     * @dataProvider provideDataGroupCarPremiumExclusive
     */
    public function testVehicleClassificationAllOnCarGroupPremiumExclusive(array $vehicleData)
    {
        // Map vehicle
        $mapper = new VehicleModelMapper();
        $vehicle = $mapper->toVehicle($vehicleData);
        $this->assertInstanceOf(Vehicle::class, $vehicle);

        $vehicleClassification = VehicleClassification::create(DefaultGroupRulesSetsFactory::getDefaultCarGroupRulesSet());

        $classifiedId = $vehicleClassification->suggestClassifications($vehicle);

        $this->assertEquals(GroupRulesInterface::GROUP_CARS_PREMIUM_EXCLUSIVE_ID, $classifiedId[0]);
    }

    /**
     * @return array<array<array>>
     */
    public static function provideDataGroupMotor()
    {
        return array(
            array(array(
                'id' => '31',
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 14507,
                'makeName' => 'PIAGGIO',
                'modelName' => 'M64',
                'yearOfManufacture' => 2009,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4750
            )),
            array(array(
                'id' => '32',
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 22000,
                'makeName' => 'YAMAHA',
                'modelName' => 'XT 660 R',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 3300
            )),
            array(array(
                'id' => '33',
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 19700,
                'makeName' => 'DUCATI',
                'modelName' => 'MONSTER 796',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 6000
            )),
            array(array(
                'id' => '34',
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 11000,
                'makeName' => 'BENZHOU',
                'modelName' => 'IVA LUX50',
                'yearOfManufacture' => 2011,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 650
            )),
            array(array(
                'id' => '35',
                'vehicleType' => Vehicle::TYPE_MOTOR,
                'damageFree' => '1',
                'mileage' => 25850,
                'makeName' => 'HONDA',
                'modelName' => 'NC700D',
                'yearOfManufacture' => 2012,
                'fuelType' => '1',
                'bpm' => '0',
                'askingPrice' => 4250
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideDataGroupCarExport()
    {
        return array(
            array(array(
                'id' => '1',
                'licensePlate' => '44NJTB',
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => '1',
                'drivable' => '1',
                'mileage' => 316000,
                'makeName' => 'SAAB',
                'modelName' => '9-3',
                'yearOfManufacture' => 2003,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => '10156',
                'numberOfDoors' => 5,
                'askingPrice' => '1650'
            ))
        );
    }

    /**
     * @return array<array<array>>
     */
    public static function provideDataGroupCarPremiumExclusive()
    {
        return array(
            array(array(
                'id' => '27',
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 144000,
                'makeName' => 'SPYKER',
                'yearOfManufacture' => 1979,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 15000,
                'actualValue' => 10000,
                'numberOfDoors' => 2
            )),
            array(array(
                'id' => '28',
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 77000,
                'makeName' => 'MORGAN',
                'yearOfManufacture' => 1966,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 11000,
                'askingPrice' => 39000,
                'actualValue' => 40000,
                'numberOfDoors' => 2
            )),
            array(array(
                'id' => '29',
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 44000,
                'makeName' => 'PORSCHE',
                'modelName' => '911 TURBO',
                'yearOfManufacture' => 1986,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 0,
                'askingPrice' => 72000,
                'listPrice' => 100000,
                'numberOfDoors' => 2
            )),
            array(array(
                'id' => '30',
                'vehicleType' => Vehicle::TYPE_CAR,
                'damageFree' => true,
                'drivable' => true,
                'mileage' => 86000,
                'makeName' => 'PORSCHE',
                'modelName' => 'CARRERA',
                'yearOfManufacture' => 1999,
                'fuelType' => FuelUtils::GASOLINE,
                'bpm' => 8000,
                'askingPrice' => 65000,
                'listPrice' => 89000,
                'numberOfDoors' => 2
            )),
        );
    }
}
