<?php

namespace Dealerdirect\VehicleClassification\Models;

/**
 * Class CarOption
 *
 * Car options model.
 * Contains constants specifying all static Dealerdirect Car option values.
 *
 * @package Dealerdirect\VehicleClassification\Models
 */
class CarOption implements VehicleOptionInterface
{
    /**
     * Air Conditioning
     */
    public const AIR_CONDITIONING = 1;

    /**
     * ABS - Anti locking brake system
     */
    public const ABS = 2;

    /**
     * 4x4
     */
    public const FOUR_BY_FOUR = 3;

    /**
     * Automatic Air Conditiong / Climate Control
     */
    public const AIR_CONDITIONING_AUTOMATIC = 4;
    public const CLIMATE_CONTROL = 4;

    public const AIRBAG = 5;

    /**
     * Vehicle has (additional) tuning
     */
    public const TUNING = 6;

    /**
     * Leather upholstery / interior ("Leren bekleding")
     */
    public const LEATHER_UPHOLSTERY = 7;

    /**
     * Passenger's side airbag
     */
    public const AIRBAG_PASSENGER_SIDE = 8;

    /**
     * Alloy wheels ("Lichtmetalen velgen")
     */
    public const ALLOY_WHEELS = 9;

    public const ELECTRIC_WINDOWS = 10;

    /**
     * Side airbags
     */
    public const AIRBAGS_SIDE = 11;

    public const ROOF_RAILS = 12;

    /**
     * GPS / Navigation
     */
    public const GPS_NAVIGATION = 13;

    /**
     * Xenon headlights
     */
    public const XENON_LIGHTS = 14;

    /**
     * On-board Computer ("Boordcomputer")
     */
    public const ONBOARD_COMPUTER = 15;

    public const POWER_SEATS = 16;

    public const POWER_DOOR_LOCKS = 17;

    /**
     * Parking assistance
     */
    public const PARKING_ASSIST = 18;

    /**
     * Sun/Moon Roof
     */
    public const SUN_ROOF = 19;

    /**
     * Alarm system
     */
    public const ALARM = 20;

    public const FOG_LIGHTS = 21;

    public const HEATED_SEATS = 22;

    public const IMMOBILIZER = 23;

    public const POWER_STEERING = 24;

    /**
     * CD Player
     */
    public const AUDIO_CD_PLAYER = 25;

    public const TRACTION_CONTROL = 26;

    public const CRUISE_CONTROL = 27;

    /**
     * Radio/cassette
     */
    public const AUDIO_RADIO_CASSETTE = 28;

    /**
     * ESP - Electronic stability program
     */
    public const ESP = 29;

    /**
     * Towbar ("Trekhaak")
     */
    public const TOWBAR = 30;

    /**
     * Panoramic Sun Roof
     */
    public const SUN_ROOF_PANORAMIC = 31;
}
