<?php

namespace Dealerdirect\VehicleClassification\Rules\Bicycle;

use Dealerdirect\VehicleClassification\Rules\Operators\CatchAll;
use Dealerdirect\VehicleClassification\Rules\RuleBuilder;
use Dealerdirect\VehicleClassification\Rules\RuleSet as BaseRuleSet;
use Ruler\Operator\LogicalAnd;

class RuleSet extends BaseRuleSet
{
    public const GROUP_NO_ID = 0;
    public const GROUP_YOUNG_ID = 60;
    public const GROUP_DEMOLITION_ID = 61;

    public function __construct()
    {
        $rb = new RuleBuilder();
        $currentYear = (int)date('Y');

        // TODO: Change these rules as rules are not yet spicified.
        $this->addRule(
            $rb->create(
                new LogicalAnd([
                    $rb['yearOfManufacture']->greaterThan($currentYear - 6)
                ]),
                self::GROUP_YOUNG_ID
            )
        );

        // Catch all
        $this->addRule(
            $rb->create(
                new CatchAll(),
                self::GROUP_DEMOLITION_ID
            )
        );
    }
}
